/*
 * Decompiled with CFR 0.152.
 */
package jenkins.monitor;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import hudson.security.Permission;
import java.io.IOException;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.NavigableMap;
import java.util.TreeMap;
import jenkins.model.Jenkins;
import jenkins.monitor.Messages;
import jenkins.util.SystemProperties;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
@Restricted(value={NoExternalUse.class})
@Symbol(value={"javaVersionRecommendation"})
public class JavaVersionRecommendationAdminMonitor
extends AdministrativeMonitor {
    private static final NavigableMap<Integer, LocalDate> SUPPORTED_JAVA_VERSIONS;
    private static Boolean disabled;

    public JavaVersionRecommendationAdminMonitor() {
        super(JavaVersionRecommendationAdminMonitor.getId());
    }

    private static String getId() {
        StringBuilder id = new StringBuilder();
        id.append(JavaVersionRecommendationAdminMonitor.class.getName());
        LocalDate endOfLife = JavaVersionRecommendationAdminMonitor.getEndOfLife();
        if (endOfLife.isBefore(LocalDate.MAX)) {
            id.append('-');
            id.append(Runtime.version().feature());
            id.append('-');
            id.append(endOfLife);
            id.append('-');
            id.append((Object)JavaVersionRecommendationAdminMonitor.getSeverity());
        }
        return id.toString();
    }

    @Override
    public boolean isActivated() {
        return disabled == false && JavaVersionRecommendationAdminMonitor.getDeprecationPeriod().toTotalMonths() < 12L;
    }

    @Override
    public String getDisplayName() {
        return Messages.JavaLevelAdminMonitor_DisplayName();
    }

    @Override
    public Permission getRequiredPermission() {
        return Jenkins.SYSTEM_READ;
    }

    @Restricted(value={DoNotUse.class})
    @RequirePOST
    public HttpResponse doAct(@QueryParameter String no) throws IOException {
        if (no != null) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            this.disable(true);
            return HttpResponses.forwardToPreviousPage();
        }
        return new HttpRedirect("https://jenkins.io/redirect/java-support/");
    }

    @NonNull
    private static LocalDate getEndOfLife() {
        LocalDate endOfLife = (LocalDate)SUPPORTED_JAVA_VERSIONS.get(Runtime.version().feature());
        return endOfLife != null ? endOfLife : LocalDate.MAX;
    }

    @NonNull
    private static Period getDeprecationPeriod() {
        return Period.between(LocalDate.now(), JavaVersionRecommendationAdminMonitor.getEndOfLife());
    }

    @NonNull
    private static Severity getSeverity() {
        return JavaVersionRecommendationAdminMonitor.getDeprecationPeriod().toTotalMonths() < 3L ? Severity.DANGER : Severity.WARNING;
    }

    @Restricted(value={DoNotUse.class})
    public int getJavaVersion() {
        return Runtime.version().feature();
    }

    @Restricted(value={DoNotUse.class})
    public Date getEndOfLifeAsDate() {
        return Date.from(JavaVersionRecommendationAdminMonitor.getEndOfLife().atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    @Restricted(value={DoNotUse.class})
    public String getSeverityAsString() {
        return JavaVersionRecommendationAdminMonitor.getSeverity().toString().toLowerCase(Locale.US);
    }

    static {
        TreeMap<Integer, LocalDate> supportedVersions = new TreeMap<Integer, LocalDate>();
        supportedVersions.put(17, LocalDate.of(2026, 3, 31));
        supportedVersions.put(21, LocalDate.of(2027, 9, 30));
        SUPPORTED_JAVA_VERSIONS = Collections.unmodifiableNavigableMap(supportedVersions);
        disabled = SystemProperties.getBoolean(JavaVersionRecommendationAdminMonitor.class.getName() + ".disabled", false);
    }

    private static enum Severity {
        SUCCESS,
        INFO,
        WARNING,
        DANGER;

    }
}

