/*
 * Decompiled with CFR 0.152.
 */
package hudson.model.userproperty;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.util.FormApply;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.verb.POST;

public abstract class UserPropertyCategoryAction {
    private final User targetUser;

    public UserPropertyCategoryAction(User targetUser) {
        this.targetUser = targetUser;
    }

    @NonNull
    public User getTargetUser() {
        return this.targetUser;
    }

    @NonNull
    public abstract List<UserPropertyDescriptor> getMyCategoryDescriptors();

    @POST
    public void doConfigSubmit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException, Descriptor.FormException {
        this.targetUser.checkPermission(Jenkins.ADMINISTER);
        JSONObject json = req.getSubmittedForm();
        ArrayList<UserProperty> props = new ArrayList<UserProperty>();
        List<UserPropertyDescriptor> myCategoryDescriptors = this.getMyCategoryDescriptors();
        int i = 0;
        for (UserPropertyDescriptor d : myCategoryDescriptors) {
            JSONObject o;
            Object p = this.targetUser.getProperty(d.clazz);
            if ((o = json.optJSONObject("userProperty" + i++)) != null) {
                p = p != null ? ((UserProperty)p).reconfigure(req, o) : (UserProperty)d.newInstance(req, o);
            }
            if (p == null) continue;
            props.add((UserProperty)p);
        }
        this.targetUser.addProperties(props);
        this.targetUser.save();
        FormApply.success("..").generateResponse(req, rsp, (Object)this);
    }
}

