/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ResourceActivity;
import hudson.model.Saveable;
import hudson.scm.SCM;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrappers;
import hudson.tasks.Builder;
import hudson.tasks.Fingerprinter;
import hudson.tasks.Maven;
import hudson.tasks.Publisher;
import hudson.triggers.SCMTrigger;
import hudson.triggers.Trigger;
import hudson.util.DescribableList;
import io.jenkins.servlet.ServletExceptionWrapper;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.triggers.SCMTriggerItem;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.StaplerResponse2;

public abstract class Project<P extends Project<P, B>, B extends Build<P, B>>
extends AbstractProject<P, B>
implements SCMTriggerItem,
Saveable,
Maven.ProjectWithMaven,
BuildableItemWithBuildWrappers {
    private volatile DescribableList<Builder, Descriptor<Builder>> builders;
    private static final AtomicReferenceFieldUpdater<Project, DescribableList> buildersSetter = AtomicReferenceFieldUpdater.newUpdater(Project.class, DescribableList.class, "builders");
    private volatile DescribableList<Publisher, Descriptor<Publisher>> publishers;
    private static final AtomicReferenceFieldUpdater<Project, DescribableList> publishersSetter = AtomicReferenceFieldUpdater.newUpdater(Project.class, DescribableList.class, "publishers");
    private volatile DescribableList<BuildWrapper, Descriptor<BuildWrapper>> buildWrappers;
    private static final AtomicReferenceFieldUpdater<Project, DescribableList> buildWrappersSetter = AtomicReferenceFieldUpdater.newUpdater(Project.class, DescribableList.class, "buildWrappers");
    private static final Logger LOGGER = Logger.getLogger(Project.class.getName());

    protected Project(ItemGroup parent, String name) {
        super(parent, name);
    }

    @Override
    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        super.onLoad(parent, name);
        this.getBuildersList().setOwner(this);
        this.getPublishersList().setOwner(this);
        this.getBuildWrappersList().setOwner(this);
    }

    @Override
    public AbstractProject<?, ?> asProject() {
        return this;
    }

    @Override
    public Item asItem() {
        return this;
    }

    @Override
    public SCMTrigger getSCMTrigger() {
        return this.getTrigger(SCMTrigger.class);
    }

    @Override
    public Collection<? extends SCM> getSCMs() {
        return SCMTriggerItem.SCMTriggerItems.resolveMultiScmIfConfigured(this.getScm());
    }

    public List<Builder> getBuilders() {
        return this.getBuildersList().toList();
    }

    @Deprecated
    public Map<Descriptor<Publisher>, Publisher> getPublishers() {
        return this.getPublishersList().toMap();
    }

    public DescribableList<Builder, Descriptor<Builder>> getBuildersList() {
        if (this.builders == null) {
            buildersSetter.compareAndSet(this, null, new DescribableList(this));
        }
        return this.builders;
    }

    @Override
    public DescribableList<Publisher, Descriptor<Publisher>> getPublishersList() {
        if (this.publishers == null) {
            publishersSetter.compareAndSet(this, null, new DescribableList(this));
        }
        return this.publishers;
    }

    public Map<Descriptor<BuildWrapper>, BuildWrapper> getBuildWrappers() {
        return this.getBuildWrappersList().toMap();
    }

    @Override
    public DescribableList<BuildWrapper, Descriptor<BuildWrapper>> getBuildWrappersList() {
        if (this.buildWrappers == null) {
            buildWrappersSetter.compareAndSet(this, null, new DescribableList(this));
        }
        return this.buildWrappers;
    }

    @Override
    protected Set<ResourceActivity> getResourceActivities() {
        HashSet<ResourceActivity> activities = new HashSet<ResourceActivity>();
        activities.addAll(super.getResourceActivities());
        activities.addAll(Util.filter(this.getBuildersList(), ResourceActivity.class));
        activities.addAll(Util.filter(this.getPublishersList(), ResourceActivity.class));
        activities.addAll(Util.filter(this.getBuildWrappersList(), ResourceActivity.class));
        return activities;
    }

    @Deprecated
    public void addPublisher(Publisher buildStep) throws IOException {
        this.getPublishersList().add(buildStep);
    }

    @Deprecated
    public void removePublisher(Descriptor<Publisher> descriptor) throws IOException {
        this.getPublishersList().remove(descriptor);
    }

    public Publisher getPublisher(Descriptor<Publisher> descriptor) {
        for (Publisher p : this.getPublishersList()) {
            if (p.getDescriptor() != descriptor) continue;
            return p;
        }
        return null;
    }

    @Override
    protected void buildDependencyGraph(DependencyGraph graph) {
        super.buildDependencyGraph(graph);
        this.getPublishersList().buildDependencyGraph(this, graph);
        this.getBuildersList().buildDependencyGraph(this, graph);
        this.getBuildWrappersList().buildDependencyGraph(this, graph);
    }

    @Override
    public boolean isFingerprintConfigured() {
        return this.getPublishersList().get(Fingerprinter.class) != null;
    }

    @Override
    public Maven.MavenInstallation inferMavenInstallation() {
        Maven m = (Maven)this.getBuildersList().get(Maven.class);
        if (m != null) {
            return m.getMaven();
        }
        return null;
    }

    @Override
    protected void submit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, jakarta.servlet.ServletException, Descriptor.FormException {
        if (Util.isOverridden(Project.class, this.getClass(), "submit", StaplerRequest.class, StaplerResponse.class)) {
            try {
                this.submit(StaplerRequest.fromStaplerRequest2((StaplerRequest2)req), StaplerResponse.fromStaplerResponse2((StaplerResponse2)rsp));
            }
            catch (ServletException e) {
                throw ServletExceptionWrapper.toJakartaServletException((ServletException)e);
            }
        } else {
            super.submit(req, rsp);
            this.submitImpl(req, rsp);
        }
    }

    @Override
    @Deprecated
    protected void submit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        super.submit(req, rsp);
        try {
            this.submitImpl(StaplerRequest.toStaplerRequest2((StaplerRequest)req), StaplerResponse.toStaplerResponse2((StaplerResponse)rsp));
        }
        catch (jakarta.servlet.ServletException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void submitImpl(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, jakarta.servlet.ServletException, Descriptor.FormException {
        JSONObject json = req.getSubmittedForm();
        this.getBuildWrappersList().rebuild(req, json, BuildWrappers.getFor(this));
        this.getBuildersList().rebuildHetero(req, json, Builder.all(), "builder");
        this.getPublishersList().rebuildHetero(req, json, Publisher.all(), "publisher");
    }

    @Override
    protected List<Action> createTransientActions() {
        List<Action> r = super.createTransientActions();
        for (BuildStep buildStep : this.getBuildersList()) {
            try {
                r.addAll(buildStep.getProjectActions(this));
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.SEVERE, "Error loading build step.", e);
            }
        }
        for (BuildStep buildStep : this.getPublishersList()) {
            try {
                r.addAll(buildStep.getProjectActions(this));
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.SEVERE, "Error loading publisher.", e);
            }
        }
        for (BuildWrapper buildWrapper : this.getBuildWrappers().values()) {
            try {
                r.addAll(buildWrapper.getProjectActions(this));
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.SEVERE, "Error loading build wrapper.", e);
            }
        }
        for (Trigger trigger : this.triggers()) {
            try {
                r.addAll(trigger.getProjectActions());
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.SEVERE, "Error loading trigger.", e);
            }
        }
        return r;
    }
}

