/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient.cgit;

import com.google.common.util.concurrent.MoreExecutors;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.util.DaemonThreadFactory;
import hudson.util.ExceptionCatchingThreadFactory;
import hudson.util.NamingThreadFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class GitCommandsExecutor {
    private final int threads;
    private final TaskListener listener;

    public GitCommandsExecutor(int threads, TaskListener listener) {
        this.threads = Math.max(1, threads);
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void invokeAll(Collection<Callable<T>> commands) throws GitException, InterruptedException {
        Object executorService = null;
        try {
            if (this.threads == 1) {
                executorService = MoreExecutors.newDirectExecutorService();
            } else {
                ExceptionCatchingThreadFactory threadFactory = new ExceptionCatchingThreadFactory((ThreadFactory)new NamingThreadFactory((ThreadFactory)new DaemonThreadFactory(), GitCommandsExecutor.class.getSimpleName()));
                executorService = Executors.newFixedThreadPool(this.threads, (ThreadFactory)threadFactory);
            }
            this.invokeAll((ExecutorService)executorService, commands);
        }
        finally {
            if (executorService != null) {
                executorService.shutdownNow();
                if (!executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                    this.listener.getLogger().println("[WARNING] Threads did not terminate properly");
                }
            }
        }
    }

    private <T> void invokeAll(ExecutorService executorService, Collection<Callable<T>> commands) throws InterruptedException {
        int i;
        ExecutorCompletionService completionService = new ExecutorCompletionService(executorService);
        Iterator<Callable<T>> remainingCommands = commands.iterator();
        int nCommands = commands.size();
        for (i = 0; i < this.threads && i < nCommands; ++i) {
            this.submitRemainingCommand(completionService, remainingCommands);
        }
        for (i = 0; i < nCommands; ++i) {
            this.checkResult(completionService.take());
            this.submitRemainingCommand(completionService, remainingCommands);
        }
    }

    private <T> void submitRemainingCommand(CompletionService<T> completionService, Iterator<Callable<T>> remainingCommands) {
        if (remainingCommands.hasNext()) {
            completionService.submit(remainingCommands.next());
        }
    }

    private <T> void checkResult(Future<T> result) throws InterruptedException {
        try {
            result.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InterruptedException) {
                throw (InterruptedException)new InterruptedException().initCause(cause);
            }
            throw new GitException(cause);
        }
    }
}

