/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.plugins.git.GitObject;
import java.util.Objects;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;

public class Branch
extends GitObject {
    private static final long serialVersionUID = 1L;

    public Branch(String name, ObjectId sha1) {
        super(name, sha1);
    }

    public Branch(Ref candidate) {
        super(Branch.strip(candidate.getName()), candidate.getObjectId());
    }

    private static String strip(String name) {
        return name.substring(name.indexOf(47, 5) + 1);
    }

    public String toString() {
        return String.format("Branch %s(%s)", this.name, this.getSHA1String());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.sha1);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Branch other = (Branch)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.sha1, other.sha1);
    }
}

