/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Messages;
import hudson.ProxyConfiguration;
import hudson.model.Descriptor;
import java.io.IOException;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;

@Extension
@Restricted(value={NoExternalUse.class})
public class ProxyConfigurationManager
extends GlobalConfiguration {
    @Override
    @NonNull
    public String getDisplayName() {
        return Messages.ProxyConfigurationManager_DisplayName();
    }

    public Descriptor<ProxyConfiguration> getProxyDescriptor() {
        return Jenkins.get().getDescriptor(ProxyConfiguration.class);
    }

    @Override
    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        ProxyConfiguration pc = (ProxyConfiguration)req.bindJSON(ProxyConfiguration.class, json);
        try {
            ProxyConfigurationManager.saveProxyConfiguration(pc);
        }
        catch (IOException e) {
            throw new Descriptor.FormException(e.getMessage(), e, null);
        }
        return true;
    }

    public static void saveProxyConfiguration(ProxyConfiguration pc) throws IOException {
        Jenkins jenkins = Jenkins.get();
        if (pc.name == null) {
            jenkins.proxy = null;
            ProxyConfiguration.getXmlFile().delete();
        } else {
            jenkins.proxy = pc;
            jenkins.proxy.save();
        }
    }
}

