/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.protocol.cert;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.Socket;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import net.jcip.annotations.GuardedBy;
import org.jenkinsci.remoting.util.KeyUtils;

public class PublicKeyMatchingX509ExtendedTrustManager
extends X509ExtendedTrustManager {
    @GuardedBy(value="self")
    private final List<PublicKey> publicKeys;
    private final boolean strictClient;
    private final boolean strictServer;

    public PublicKeyMatchingX509ExtendedTrustManager(PublicKey ... publicKeys) {
        this(true, true, publicKeys);
    }

    public PublicKeyMatchingX509ExtendedTrustManager(boolean strictClient, boolean strictServer, PublicKey ... publicKeys) {
        this.publicKeys = new ArrayList<PublicKey>(Arrays.asList(publicKeys));
        this.strictClient = strictClient;
        this.strictServer = strictServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(@NonNull PublicKey publicKey) {
        List<PublicKey> list = this.publicKeys;
        synchronized (list) {
            for (PublicKey k : this.publicKeys) {
                if (!KeyUtils.equals(publicKey, k)) continue;
                return false;
            }
            this.publicKeys.add(publicKey);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(PublicKey publicKey) {
        List<PublicKey> list = this.publicKeys;
        synchronized (list) {
            Iterator<PublicKey> iterator = this.publicKeys.iterator();
            while (iterator.hasNext()) {
                PublicKey k = iterator.next();
                if (!KeyUtils.equals(publicKey, k)) continue;
                iterator.remove();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTrusted(PublicKey publicKey) {
        List<PublicKey> list = this.publicKeys;
        synchronized (list) {
            for (PublicKey k : this.publicKeys) {
                if (!KeyUtils.equals(publicKey, k)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<PublicKey> list = this.publicKeys;
        synchronized (list) {
            this.publicKeys.clear();
        }
    }

    private static void validateAuthType(String authType) {
        if (authType == null) {
            throw new IllegalArgumentException("authType must not be null");
        }
        if (authType.isEmpty()) {
            throw new IllegalArgumentException("authType must not be zero-length");
        }
    }

    private static void validateChain(X509Certificate[] chain) {
        if (chain == null) {
            throw new IllegalArgumentException("chain must not be null");
        }
        if (chain.length == 0) {
            throw new IllegalArgumentException("chain must not be zero-length");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPublicKey(boolean client, X509Certificate[] chain) throws CertificateException {
        PublicKey chainKey = chain[0].getPublicKey();
        byte[] chainKeyEncoded = chainKey.getEncoded();
        if (chainKeyEncoded == null) {
            throw new CertificateException(String.format("Public key of the first certificate in chain (subject: '%s') (algorithm: '%s'; format: '%s') does not support binary encoding", chain[0].getSubjectDN(), chainKey.getAlgorithm(), chainKey.getFormat()));
        }
        List<PublicKey> list = this.publicKeys;
        synchronized (list) {
            if (this.publicKeys.isEmpty() ? (client ? !this.strictClient : !this.strictServer) : this.isTrusted(chainKey)) {
                return;
            }
        }
        throw new CertificateException(String.format("Public key of the first certificate in chain (subject: %s) is not in the list of trusted keys", chain[0].getSubjectDN()));
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        PublicKeyMatchingX509ExtendedTrustManager.validateAuthType(authType);
        PublicKeyMatchingX509ExtendedTrustManager.validateChain(chain);
        this.checkPublicKey(true, chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        PublicKeyMatchingX509ExtendedTrustManager.validateAuthType(authType);
        PublicKeyMatchingX509ExtendedTrustManager.validateChain(chain);
        this.checkPublicKey(false, chain);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        PublicKeyMatchingX509ExtendedTrustManager.validateAuthType(authType);
        PublicKeyMatchingX509ExtendedTrustManager.validateChain(chain);
        this.checkPublicKey(true, chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        PublicKeyMatchingX509ExtendedTrustManager.validateAuthType(authType);
        PublicKeyMatchingX509ExtendedTrustManager.validateChain(chain);
        this.checkPublicKey(false, chain);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        PublicKeyMatchingX509ExtendedTrustManager.validateAuthType(authType);
        PublicKeyMatchingX509ExtendedTrustManager.validateChain(chain);
        this.checkPublicKey(true, chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        PublicKeyMatchingX509ExtendedTrustManager.validateAuthType(authType);
        PublicKeyMatchingX509ExtendedTrustManager.validateChain(chain);
        this.checkPublicKey(false, chain);
    }

    @Override
    @SuppressFBWarnings(value={"WEAK_TRUST_MANAGER"}, justification="An intentionally overtrusting manager.")
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

