/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

class HostPort {
    private static final int PORT_MIN = 0;
    private static final int PORT_MAX = 65535;
    private String host;
    private int port;

    public HostPort(String value) {
        this.splitHostPort(value, null, 0);
    }

    public HostPort(String value, String defaultHost, int defaultPort) {
        this.splitHostPort(value, defaultHost, defaultPort);
    }

    private void splitHostPort(String value, String defaultHost, int defaultPort) {
        String hostPortValue = value.trim();
        if (hostPortValue.charAt(0) == '[') {
            this.extractIPv6(hostPortValue);
            return;
        }
        int portSeparator = hostPortValue.lastIndexOf(58);
        if (portSeparator < 0) {
            throw new IllegalArgumentException("Invalid HOST:PORT value: " + value);
        }
        String hostValue = hostPortValue.substring(0, portSeparator).trim();
        this.host = hostValue.length() > 0 ? hostValue : defaultHost;
        String portString = hostPortValue.substring(portSeparator + 1).trim();
        if (portString.length() > 0) {
            this.port = Integer.parseInt(portString);
            if (this.port <= 0 || this.port > 65535) {
                throw new IllegalArgumentException("Port " + value + " out of valid range [0, 65535)");
            }
        } else {
            this.port = defaultPort;
        }
    }

    private void extractIPv6(String hostPortValue) {
        int endBracket = hostPortValue.indexOf(93);
        if (endBracket < 2) {
            throw new IllegalArgumentException("Invalid IPv6 value.");
        }
        this.host = hostPortValue.substring(1, endBracket).trim();
        int portSeparator = hostPortValue.lastIndexOf(58);
        if (portSeparator < endBracket) {
            throw new IllegalArgumentException("Missing port.");
        }
        this.port = Integer.parseInt(hostPortValue.substring(portSeparator + 1).trim());
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

