/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.remoting.Callable;
import hudson.remoting.Future;
import hudson.remoting.VirtualChannel;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class LocalChannel
implements VirtualChannel {
    private final ExecutorService executor;

    public LocalChannel(ExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public <V, T extends Throwable> V call(Callable<V, T> callable) throws T {
        return callable.call();
    }

    @Override
    public <V, T extends Throwable> Future<V> callAsync(@NonNull Callable<V, T> callable) {
        final java.util.concurrent.Future<Object> f = this.executor.submit(() -> {
            try {
                return callable.call();
            }
            catch (Error | Exception t) {
                throw t;
            }
            catch (Throwable t) {
                throw new ExecutionException(t);
            }
        });
        return new Future<V>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return f.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return f.isCancelled();
            }

            @Override
            public boolean isDone() {
                return f.isDone();
            }

            @Override
            public V get() throws InterruptedException, ExecutionException {
                return f.get();
            }

            @Override
            public V get(long timeout, @NonNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return f.get(timeout, unit);
            }
        };
    }

    @Override
    public void close() {
    }

    @Override
    public void join() throws InterruptedException {
    }

    @Override
    public void join(long timeout) throws InterruptedException {
    }

    @Override
    public <T> T export(@NonNull Class<T> intf, T instance) {
        return instance;
    }

    @Override
    public void syncLocalIO() throws InterruptedException {
    }
}

